// routes/push.js - CORRECTED VERSION

const express = require('express');
const { pool } = require('../config/database');
const router = express.Router();

// Route to save a new subscription
router.post('/subscribe', async (req, res) => {
    const { subscription } = req.body;
    
    // --- START OF CORRECTION ---
    // Fixed from req.user.id to req.user.userId
    const userId = req.user.userId; 
    // --- END OF CORRECTION ---

    if (!subscription || !subscription.endpoint) {
        return res.status(400).json({ error: 'Invalid subscription' });
    }

    // Added a log to verify user ID
    console.log(`[PUSH SUBSCRIBE] Attempting to save subscription for userId: ${userId}`);

    if (!userId) {
        return res.status(400).json({ error: 'User ID not found in token.' });
    }

    try {
        const subscriptionJson = JSON.stringify(subscription);
        
        // Check if subscription already exists to avoid duplicates
        const [existing] = await pool.execute(
            'SELECT id FROM push_subscriptions WHERE user_id = ? AND subscription = ?',
            [userId, subscriptionJson]
        );

        if (existing.length === 0) {
            await pool.execute(
                'INSERT INTO push_subscriptions (user_id, subscription) VALUES (?, ?)',
                [userId, subscriptionJson]
            );
            console.log(`[PUSH SUBSCRIBE] New subscription saved for userId: ${userId}`);
        } else {
            console.log(`[PUSH SUBSCRIBE] Subscription already exists for userId: ${userId}. No action needed.`);
        }
        
        res.status(201).json({ message: 'Subscription saved successfully' });
    } catch (error) {
        console.error('Error saving subscription:', error);
        res.status(500).json({ error: 'Internal server error saving subscription' });
    }
});

module.exports = router;