const express = require("express");
const router = express.Router();
const { pool } = require("../config/database");

/**
 * Public route to get profile settings (name, colors, logos, favicon)
 * Used on the login screen to apply customizations without authentication
 */
router.get("/profile-settings", async (req, res) => {
  let connection;
  try {
    connection = await pool.getConnection();

    // Fetch settings from bot_settings table (same one used by admin)
    const [rows] = await connection.execute(
      "SELECT setting_value FROM bot_settings WHERE setting_key = ?",
      ["profile_settings"]
    );

    if (rows.length > 0) {
      const settings = JSON.parse(rows[0].setting_value);
      res.json(settings);
    } else {
      // Return default values if there are no settings
      res.json({
        systemName: "Misayan Admin",
        customColors: null,
        loginLogo: null,
        systemLogo: null,
        favicon: null,
        loginBodyColor: null,
        loginCardColor: null,
      });
    }
  } catch (error) {
    console.error("Error fetching public settings:", error);
    // Return default values in case of error
    res.json({
      systemName: "Misayan Admin",
      customColors: null,
      loginLogo: null,
      systemLogo: null,
      favicon: null,
      loginBodyColor: null,
      loginCardColor: null,
    });
  } finally {
    if (connection) connection.release();
  }
});

module.exports = router;
