/**
 * Authentication Routes
 * 
 * All authentication-related endpoints
 */

const express = require('express');
const AuthController = require('../controllers/AuthController');

const router = express.Router();

// Login route: POST /api/auth/login
router.post('/login', AuthController.login);

// Verify token: GET /api/auth/verify
router.get('/verify', AuthController.verify);

// Logout route: POST /api/auth/logout
router.post('/logout', AuthController.logout);

module.exports = router;